## About
# Here I analyze the profilometer data.
# I calculate the mean thickness and the bottom thickness.
# I only include the central data part between 5 - 13 mm in these calculations,
# Because in this range, I am certain I am excluding the glass slide and/or edges.

## Read data
files <- list.files(path="//st-a2355/tomo5/Hazendonk_Laura/1_StretchableGink/Data/Profilometer/LH_PU_VTT_2021-01-15", 
                    pattern="*.csv", full.names=TRUE, recursive=FALSE)
resolution <- 0.833278 # scan resolution in um

## Create empty lists to store the data
sample_lst <- vector("list", length(files))
thickness_lst <- vector("list", length(files))
std_lst <- vector("list", length(files))
baseline_lst <- vector("list", length(files))
baseline_sd_lst <- vector("list", length(files))
peaks_mean_lst <- vector("list", length(files))
peaks_sd_lst <- vector("list", length(files))

## Calculations
library(stringr) # package for regular expressions
#library(pracma) # to find local minima and maxima (alternative: findPeaks or findValleys in quantmod package)
library(quantmod) # findValleys/findPeaks
for (i in 1:length(files)) {
  ## Extract sample name
  sampleName <- str_extract(files[i],"[a-zA-Z0-9()]*\\.csv$") # regex which extracts the sample from the path name.
  ## read file
  profil <- read.csv(file=files[i], header=TRUE, sep=",",dec=".",skip=22) # load file
  
  ## calculations
  profi_data_um <- profil[round(5000/resolution):round(13000/resolution),1:2]*0.0001 # convert data to microns and only take central 700 um
  # profi_data_um_full <- profil[,1:2]*0.0001 # Check full profiles
  # plot(profi_data_um_full) # check full profiles
  # plot(profi_data_um_full, xlim = c(0.3, 1.5)) # check full profiles
  # title(main = sampleName) # check full profiles
  
  # Calculate mean thickness and baseline values
  thickness_mean <- mean(profi_data_um$Total.Profile..., na.rm = TRUE)
  thickness_std <- sd(profi_data_um$Total.Profile..., na.rm = TRUE)
  
  peaks_x <- findPeaks(profi_data_um$Total.Profile..., thresh = 0)
  peaks <- profi_data_um$Total.Profile...[peaks_x]
  peaks2 <- peaks[peaks > 20] # 20 um as an arbitrary threshold for aggregates/unexfoliated flakes
  peaks_mean_lst[i] <- mean(peaks2)
  peaks_sd_lst[i] <- sd(peaks2)
  
  lows_x <- findValleys(profi_data_um$Total.Profile..., thresh = 0)
  lows <- profi_data_um$Total.Profile...[lows_x]
  lows2 <- lows[lows > 0  & lows <= mean(peaks2)] # exclude negative data (likely corresponding to pinholes) and shoulder peaks
  baseline_lst[i] <- mean(lows2)
  baseline_sd_lst[i] <- sd(lows2)
  
  ## store object in the list, by name
  sample_lst[i] <- sampleName
  thickness_lst[i] <- thickness_mean
  std_lst[i] <- thickness_std
}

## Convert lists into dataframe columns 
df <- data.frame(unlist(sample_lst), unlist(thickness_lst), unlist(std_lst), 
                 unlist(peaks_mean_lst), unlist(peaks_sd_lst),
                 unlist(baseline_lst), unlist(baseline_sd_lst)) 
# Names of columns of dataframe 
names(df) <- c("Sample", "Thickness_mean", "Thickness_sd", "Peaks_mean", 
               "Peaks_sd", "Baseline_mean", "Baseline_sd") 
print(df) 

## Write to csv
write.table(df, "//st-a2355/tomo5/Hazendonk_Laura/1_StretchableGink/Data/Profilometer/LH_PU_VTT_2021-01-15/LH_PU_VTT_2021-01-15_stats.csv",
            dec = ",", sep=";", col.names = TRUE, row.names = FALSE)
